# Collaboration as Ethos: Introduction to Volume V

Cathleen Melamed and Lini Radhakrishnan, this year’s curators and editors of *Digital Memory Project Reviews (Volume 5\)*, chose "collaboration" as the theme for this volume’s contributions, and kindly invited me to add a few introductory words.

<br>
If we understand collective memory as narratives about the past that groups of people construct, receive, and identify with, few things define it more profoundly—digitally or analog—than collaboration. Likewise, collaboration is a core value of Digital Humanities, both as a methodology and as a moral compass. DH rejects academic ivory-tower complacency by centering communities, opposing data extraction, and asking: “Who sits at the table? Whose labor is relegated to footnotes?”

<br>
This year’s editors haven’t just discussed collaboration—they have embodied it. They have honored past editors while pioneering new paths; they have empowered current authors through transparent status tracking, multimedia options, and participatory logo design; they have modeled their practice after Michelle Caswell’s “liberatory memory work.” Their feedback to reviewers reflects this ethos—meticulous, yet dialogical and generative. 

<br>
The reviews in this year’s volume mirror that spirit: my customary suggestion that student reviewers search for projects they would like to review (rather than default to my list) yielded the best results this time, with a total of 11 projects selected by them –a collaboration with the class syllabus itself. The projects they have chosen to explore are works that expand, affirm or reformulate traditional understandings of collective memory to include the memory of nature (Merlin Bird ID), 3D architectural tours (Saint Peter’s Basilica), and the memory of the incarcerated (Rikers Public Memory Project), to name just a few. I am sure that Volume V visitors will find –as I have found—that the reviewers’ evaluations are beautifully written and impressive in their depth and breadth, comprising detailed technical analyses, exhaustive critiques of content and goals, insightful appraisals of user experience, and assessments of collaborative features. The reviews are also unfailingly generous, offering ideas for improvement and acknowledging the hard work behind each project. This generosity is, yet again, a form of collaboration, this time with digital memory project creators. 

<br>
I cannot help but feel that the editors’ invitation to make “collaboration” the topic of this year’s volume, and the reviewers’ embrace of the editors’ suggestion, could not be timelier. I understand DH collaboration as a radically ethical practice in our current political moment –a time when the thin veneer of community-minded politics has been torn apart, and the law of the upper-hand, of the leverage-advantage, of the “empathy as weakness” stands exposed, no longer disguised. 

<br>
During the last two years of necropolitics, I’ve become convinced that we all –and not just DHers—must meet our students’ radical commitment to collaboration, understood as an ever-expansive concept, as large as Ariella Aïsha Azoulay’s “unlearning imperialism.” From last spring’s pro-Palestinian encampments—where collective labor built a “memory of hope” (Rigney)—to their unyielding defense of justice amid state violence, to projects like this volume, our students are willing and eager to shake and recreate the idea of a scholarly community. In considering their example, I’m reminded of Mikhail Bakhtin’s words: “…to *be* in life, to be *actually*, is to *act*, is to be unindifferent toward the once-occurrent whole.” 

<br>
Our students are unindifferent, and so should we be.

<br>
*Dr. Aránzazu Borrachero*, Professor

\-------------------------------

#Collaboration and the Collective

From its earliest days, the digital humanities have perhaps best been defined by a spirit of collaboration.  In 2012, Lisa Spiro observed that “unlike traditional humanities scholarship, which typically imagines the scholar as a solitary figure working in isolation, the digital humanities embrace collaborative, iterative, and interdisciplinary work as central to its practice and identity.” With this newest curation of digital project reviews contributed by students in Professor Aránzazu Borrachero’s class *Digital Memories: Theory and Practice,* we chose to champion the egalitarian approach that foregrounds the notion of co-creation and participatory practices integral to building collections (Tureby and Wagrell 2022). We settled on the theme of collaboration, and we strove to ensure that our classroom community’s voice was present in every possible aspect of assembling this collection, *Project Reviews Digital Memories Volume V.* Collaboration exists in several forms in the volume whether in the joint production of some of the reviews with two reviewers working together, the class contributions to the project list, the emphasis on the authorial voice, the solicitation of reviewer feedback on the editorial review process demonstrating the desire for collective improvement, the process of deciding the cover/ background image through a class vote selection from class contributions and the final look of the volume being fine-tuned based on class feedback.  
<br>
In each of the reviews presented here, students contributed their perspectives on a wide array of digital projects with the goal of enhancing their own understanding of the digital humanities framework, studying different ways of preserving digital memory and evaluating the effectiveness of varying approaches in these digital contributions. The authors utilized Miriam Posner’s approach of deconstructing digital projects to facilitate their assessment of the projects under review. They also considered the collaborative aspects of the projects and even suggested areas of further collaboration from which the projects could potentially benefit. The reviewed projects span across varying themes including activist practices mobilized to advocate for marginalized communities, platforms that voice the immigrant experience, innovative games, apps, memory and archival projects that preserve collective memories and cultural voices digitally as well as provide a space that ultimately values the human experience.

<br>
In carrying on the tradition of publishing this edition of *Digital Memories,* the editors benefited from the inherited resources of past volumes, and we contributed innovations from the current volume into that pool. The interaction provided a sense of community and led us quite organically to the theme of collaboration. The collective formed over time and across volumes has empowered the diverse student body and found a way to codify resource sharing which, in its own small way, follows the liberatory framework proposed to dismantle traditional hierarchies while facilitating “open-ended making and remaking.” (Caswell 2021). Given the ephemeral nature of digital projects at large, the current volume joins the practice of archiving digital memories in the form of these reviews.

<br>
*Lini Radhakrishnan and Cathy Melamed* 
<br>
*Editors*    
 
<br>
### **CITATIONS**  

Azoulay, Ariella Aïsha. *Potential History: Unlearning Imperialism.* Verso, 2019\.

<br>
Bakhtin, Mikhail. *Toward a Philosophy of the Act.* Translated by Vadim Liapunov, University of Texas Press, 1993, p. 42\. Emphasis original.

<br>
Caswell, Michelle. *Urgent Archives: Enacting Liberatory Memory Work.* Routledge, 2021\.

<br>
Posner, Miriam. “How Did They Make That?” 2014, archive.org/details/howdidtheymakethat

<br>
Rigney, Ann. *"The Memory of Hope: Traces of the Future in the Past."* *Memory Studies*, vol. 15, no. 3, 2022, pp. 512–528.

<br>
Spiro, Lisa. 2012. *“This Is Why We Fight: Defining the Values of the Digital Humanities.”* In *Debates in the Digital Humanities*, edited by Matthew K. Gold. University of Minnesota Press.

<br>
Tureby, M. T. and Wagrell, K. (2022). Crisis documentation and oral history: Problematizing collecting and preserving practices in a digital world. *The Oral History Review*, *49(*2), 346-376. 

